/*
 * Decompiled with CFR 0.152.
 */
package net.forixaim.battle_arts.core_assets.skills.dodge;

import java.util.UUID;
import net.forixaim.battle_arts.Config;
import net.forixaim.battle_arts.core_assets.animations.BattleAnimations;
import net.forixaim.battle_arts.core_assets.skills.BattleArtsDataKeys;
import net.forixaim.battle_arts.initialization.registry.SkillRegistry;
import net.forixaim.bs_api.battle_arts_skills.BattleArtsSkillSlots;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.Input;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import yesman.epicfight.api.animation.AnimationProvider;
import yesman.epicfight.api.animation.types.AttackAnimation;
import yesman.epicfight.api.animation.types.DodgeAnimation;
import yesman.epicfight.client.world.capabilites.entitypatch.player.LocalPlayerPatch;
import yesman.epicfight.gameasset.EpicFightSounds;
import yesman.epicfight.network.client.CPExecuteSkill;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillDataKey;
import yesman.epicfight.skill.SkillSlot;
import yesman.epicfight.skill.SkillSlots;
import yesman.epicfight.skill.dodge.DodgeSkill;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.damagesource.StunType;
import yesman.epicfight.world.entity.eventlistener.ComboCounterHandleEvent;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;

public class Trailblaze
extends DodgeSkill {
    private static final UUID EVENT_UUID = UUID.fromString("c1b3d7b3-f934-48b5-a03e-9a94ba1962a6");
    private static final AnimationProvider<DodgeAnimation> SPOT_DODGE = () -> (DodgeAnimation)BattleAnimations.IMPERATRICE_TRAILBLAZE_SPOT;
    private static final AnimationProvider<AttackAnimation> SPOT_DODGE_RIPOSTE = () -> (AttackAnimation)BattleAnimations.IMPERATRICE_SWORD_JAB3;

    public Trailblaze(DodgeSkill.Builder builder) {
        super(builder);
    }

    public void onInitiate(SkillContainer container) {
        container.getExecuter().getEventListener().addEventListener(PlayerEventListener.EventType.COMBO_COUNTER_HANDLE_EVENT, EVENT_UUID, event -> {
            if (event.getCausal() == ComboCounterHandleEvent.Causal.ANOTHER_ACTION_ANIMATION && event.getAnimation().in((AnimationProvider[])this.animations)) {
                event.setNextValue(event.getPrevValue());
            }
        });
        container.getExecuter().getEventListener().addEventListener(PlayerEventListener.EventType.DODGE_SUCCESS_EVENT, EVENT_UUID, event -> {
            if (container.getExecuter().getSkill((SkillSlot)BattleArtsSkillSlots.BATTLE_STYLE).hasSkill(SkillRegistry.IMPERATRICE_LUMIERE) && container.getExecuter().getSkill((SkillSlot)BattleArtsSkillSlots.BATTLE_STYLE).getDataManager().hasData((SkillDataKey)BattleArtsDataKeys.FLARE_BURST.get()) && ((Boolean)container.getExecuter().getSkill((SkillSlot)BattleArtsSkillSlots.BATTLE_STYLE).getDataManager().getDataValue((SkillDataKey)BattleArtsDataKeys.FLARE_BURST.get())).booleanValue() || Config.unconditionalRiposte) {
                LivingEntity attacker;
                Entity patt3838$temp;
                if (((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).m_20145_()) {
                    ((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).m_6842_(false);
                }
                if (((Boolean)container.getExecuter().getSkill((Skill)this).getDataManager().getDataValue((SkillDataKey)BattleArtsDataKeys.SPOT_DODGE.get())).booleanValue() && (patt3838$temp = event.getDamageSource().m_7639_()) instanceof LivingEntity && EpicFightCapabilities.getEntityPatch((Entity)(attacker = (LivingEntity)patt3838$temp), LivingEntityPatch.class) != null) {
                    ((ServerPlayerPatch)event.getPlayerPatch()).playSound((SoundEvent)EpicFightSounds.NEUTRALIZE_MOBS.get(), 0.0f, 0.0f);
                    ((LivingEntityPatch)EpicFightCapabilities.getEntityPatch((Entity)attacker, LivingEntityPatch.class)).applyStun(StunType.HOLD, 1.0f);
                    ((ServerPlayerPatch)event.getPlayerPatch()).playAnimationSynchronized(SPOT_DODGE_RIPOSTE.get(), 0.2f);
                }
            }
        });
    }

    public boolean canExecute(PlayerPatch<?> executor) {
        return executor.getSkill((SkillSlot)BattleArtsSkillSlots.BATTLE_STYLE).hasSkill(SkillRegistry.IMPERATRICE_LUMIERE) && (Boolean)executor.getSkill((SkillSlot)BattleArtsSkillSlots.BATTLE_STYLE).getDataManager().getDataValue((SkillDataKey)BattleArtsDataKeys.ULTIMATE_ART_ACTIVE.get()) == false && executor.getSkill((SkillSlot)SkillSlots.WEAPON_INNATE).getDataManager().hasData((SkillDataKey)BattleArtsDataKeys.CHARGE_EXECUTING.get()) && (Boolean)executor.getSkill((SkillSlot)SkillSlots.WEAPON_INNATE).getDataManager().getDataValue((SkillDataKey)BattleArtsDataKeys.CHARGE_EXECUTING.get()) == false;
    }

    public void onRemoved(SkillContainer container) {
        container.getExecuter().getEventListener().removeListener(PlayerEventListener.EventType.COMBO_COUNTER_HANDLE_EVENT, EVENT_UUID);
    }

    @OnlyIn(value=Dist.CLIENT)
    public Object getExecutionPacket(LocalPlayerPatch executer, FriendlyByteBuf args) {
        Input input = ((LocalPlayer)executer.getOriginal()).f_108618_;
        float pulse = Mth.m_14036_((float)(0.3f + EnchantmentHelper.m_220302_((LivingEntity)((LivingEntity)executer.getOriginal()))), (float)0.0f, (float)1.0f);
        input.m_214106_(false, pulse);
        int forward = input.f_108568_ ? 1 : 0;
        int backward = input.f_108569_ ? -1 : 0;
        int left = input.f_108570_ ? 1 : 0;
        int right = input.f_108571_ ? -1 : 0;
        int vertic = forward + backward;
        int horizon = left + right;
        float yRot = Minecraft.m_91087_().f_91063_.m_109153_().m_90590_();
        float degree = (float)(-(horizon * (1 - Math.abs(vertic)) + 45 * vertic * horizon)) + yRot;
        int animation = vertic == 0 ? (horizon == 0 ? 0 : (horizon >= 0 ? 2 : 3)) : (vertic >= 0 ? 0 : 1);
        CPExecuteSkill packet = new CPExecuteSkill(executer.getSkill((Skill)this).getSlotId());
        packet.getBuffer().writeInt(animation);
        packet.getBuffer().writeFloat(degree);
        return packet;
    }

    public void executeOnServer(ServerPlayerPatch executer, FriendlyByteBuf args) {
        if (((ServerPlayer)executer.getOriginal()).m_6144_()) {
            executer.getSkill((Skill)this).getDataManager().setDataSync((SkillDataKey)BattleArtsDataKeys.SPOT_DODGE.get(), (Object)true, (ServerPlayer)executer.getOriginal());
            executer.playAnimationSynchronized(SPOT_DODGE.get(), 0.0f);
        } else {
            executer.getSkill((Skill)this).getDataManager().setDataSync((SkillDataKey)BattleArtsDataKeys.SPOT_DODGE.get(), (Object)false, (ServerPlayer)executer.getOriginal());
            super.executeOnServer(executer, args);
        }
    }
}

